<?php

    require 'utilities.php';
    require 'phpword_lib.php';
    require '../comunes_php/cors.php';
    require '../comunes_php/dbconfig.php';

    // Conectar la BD
    $link = mysqli_connect(DB_SERVER, DB_USER, DB_PASS, DB_NAME) or 
                die('Error de conexion con base de datos: ' . mysqli_connect_errno());
    
    mysqli_set_charset($link,'utf8');
    date_default_timezone_set('UTC');

    error_reporting(E_ALL);

    // Obtengo los parametros enviados
    $empresa = isset($_REQUEST['empresa']) ? $_REQUEST['empresa']: -1;
    $fecha_desde = isset($_REQUEST['fdesde']) ? $_REQUEST['fdesde']: -1;
    $fecha_hasta = isset($_REQUEST['fhasta']) ? $_REQUEST['fhasta']: -1;

    $hoy = date('d-m-Y');

    // Plantilla a utilizar
    $template=TEMPLATE_DIR.DIRECTORY_SEPARATOR.pathinfo(__FILE__, PATHINFO_FILENAME).'.docx';
    
    // Template processor instance creation
    $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template);

    $sql = "SELECT mp.nombre, sum(pm.cantidad) cantidad FROM "
    . "materia_prima mp, "
    . "producto_materia_prima pm, "
    . "productos p , "
    . "vw_contratos cc, "
    . "contratos_detalle cd WHERE "
    . "cc.id=cd.contrato_id and "
    . "cd.producto_id=pm.producto_id and "
    . "pm.producto_id=p.id and "
    . "pm.materia_prima_id=mp.id and "
    . "cc.fecha_fabricado >= '$fecha_desde' and "
    . "cc.fecha_fabricado <= '$fecha_hasta' "
    . "GROUP by mp.nombre";
     
    $resultado = mysqli_query($link, $sql);
    $cant_reg = mysqli_num_rows($resultado);

    $templateProcessor->setValue('desde', utf8_encode(strip_tags($fecha_desde)));
    $templateProcessor->setValue('hasta', utf8_encode(strip_tags($fecha_hasta)));
    
    // Clono la fila de la tabla que va a mostrar los datos variables
    $templateProcessor->cloneRow('producto', $cant_reg);

    // Indice utilizado por PhpWord para armar el nombre de los tags a reemplazar 
    // en las filas creadas por cloneRow
    $index = 1;

    if ($cant_reg > 0) {
        
        // Recorro el dataset
        while ($row = mysqli_fetch_array($resultado)) {
    
        	$materia_prima = $row["nombre"];
        	$cantidad = $row["cantidad"];
       
               
            // Cargo los datos en la tabla
            $templateProcessor->setValue('producto#'.$index, utf8_encode(strip_tags($materia_prima)));
            $templateProcessor->setValue('cantidad#'.$index, utf8_encode(strip_tags($cantidad)));
            
            $index += 1;
            
        }
        
        // Armo el nombre del archivo a grabar
        $filename = 'reporte_consumos_'.$fecha_desde.'_'.$fecha_hasta.'.docx';
        $fullFilename = 'generados'.DIRECTORY_SEPARATOR.$filename;
    
        // Guardo el archivo generado
        $templateProcessor->saveAs($fullFilename);    
        
        // Descarga el archivo en el cliente
        download_report($fullFilename);
        
    
        // Borra el archivo generado
        unlink($fullFilename); 
    }
    else {
        // No hay registros para listar
        $mensaje = "No hay registros para listar";
        $result = array(
                "msg" =>limpiar_caracteres_especiales($mensaje) ,
                "estado" => true
                );
    
        echo json_encode($result);
    }
    
?>