<?php
	
    require_once  'vendor/autoload.php';
	require_once 'vendor/phpoffice/phpword/bootstrap.php';
	
    
    use PhpOffice\PhpWord\Settings;
    
    define("TEMPLATE_DIR", "./templates");
    define('PAGEBREAK', '<w:p><w:r><w:br w:type="page"/></w:r></w:p>');
	
	Settings::loadConfig();



	
	// Descarga el reporte generado
	function download_report($nombre_reporte)
	{

		// Obtengo el nombre del reporte excluyendo la ruta
		$filename = basename($nombre_reporte);

		// Arma las cabeceras HTML para descargar el archivo
		header('Content-Description: File Transfer');
		header('Content-type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');

        //header('Content-Type: application/octet-stream');
        //header('Content-Transfer-Encoding: binary');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($nombre_reporte));
        
        ob_clean();
        flush();
        readfile($nombre_reporte);
        
	}


    function download_report2($nombre_reporte) {
        
  		// Obtengo el nombre del reporte excluyendo la ruta
		$filename = basename($nombre_reporte);

		// Arma las cabeceras HTML para descargar el archivo
		header('Content-Description: File Transfer');
		//header('Content-type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');

        header('Content-Type: application/octet-stream');
        header('Content-Transfer-Encoding: binary');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($nombre_reporte));
        
        //ob_clean();
        flush();
        readfile($nombre_reporte);
    }
    
    /**
    * Generar un archivo PDF
    *
    * @param string $source
    */
    function generarPdf($source)
    {
        Settings::loadConfig();

		$file = basename($source); 
		$file = explode('.', $file); 

		$file = 'generados/' . $file[0]; 
		$extension = $file[1];  
        
        $dompdfPath = 'vendor/dompdf/dompdf';

    	if (file_exists($dompdfPath)) {
   			define('DOMPDF_ENABLE_AUTOLOAD', false);
    		Settings::setPdfRenderer(Settings::PDF_RENDERER_DOMPDF, $dompdfPath);
		}    
        //\PhpOffice\PhpWord\Settings::setPdfRendererPath($dompdfPath);
        //\PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');

        // Turn output escaping on
        Settings::setOutputEscapingEnabled(true); 

    	$phpWord = \PhpOffice\PhpWord\IOFactory::load($source);        

        //$phpWord->save($file.'.pdf', 'PDF');
        Gears\Pdf::convert($source, $file.'.pdf');
        //$phpWord->save($file.'.html', 'HTML');
    }
?>