<?php

    require 'utilities.php';
    require 'phpword_lib.php';
    require '../comunes_php/cors.php';
    require '../comunes_php/dbconfig.php';

    include '../comunes_php/Log.class.php'; 
    $log = new Log("app_trace", "./");
    
    // Conectar la BD
    $link = mysqli_connect(DB_SERVER, DB_USER, DB_PASS, DB_NAME) or die('Error de conexion con base de datos: ' . mysqli_connect_errno());
    mysqli_set_charset($link,'utf8');

    date_default_timezone_set('UTC');
    error_reporting(E_ALL);


    $hoy = date('Y-m-d');
    
    // Obtengo los parametros enviados
    $id = isset($_REQUEST['id']) ? $_REQUEST['id']: -1;


    // Plantilla a utilizar
    $template=TEMPLATE_DIR.DIRECTORY_SEPARATOR.pathinfo(__FILE__, PATHINFO_FILENAME).'.docx';
    
    // Template processor instance creation
    $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template);

    $templateProcessor->setValue('fechaenvio', $hoy);            

    $sql  = "SELECT cc.id as contrato_id, cl.nombre as cliente, cl.cuit as cuit, cc.direccion, zn.nombre as zona, r.nombre as repartidor, ec.fecha_envio,(select nombre from camiones where id=ec.camion_id) camion ";
    $sql .= "FROM envios_cabecera ec, envios_detalle ed, contratos_cabecera cc, clientes cl, zonas zn, repartidores r ";
    $sql .= "WHERE ec.id = ed.envio_id ";
    $sql .= "AND ed.contrato_id = cc.id ";
    $sql .= "AND cc.cliente_id = cl.id ";
    $sql .= "AND cc.zona_id = zn.id ";
    $sql .= "AND ec.repartidor_id = r.id ";
    $sql .= "AND ec.id = $id";
     
    $log->insert($sql, false, false, false);
    
    $resultado = mysqli_query($link, $sql);
    $cant_reg = mysqli_num_rows($resultado);

    if ($cant_reg > 0) {
        // Clono la fila de la tabla que va a mostrar los datos variables
        $templateProcessor->cloneRow('id', $cant_reg);
    
        // Indice utilizado por PhpWord para armar el nombre de los tags a reemplazar 
        // en las filas creadas por cloneRow
        $index = 1;
    
        // Recorro el dataset
        while ($row = mysqli_fetch_array($resultado)) {
    
        	$cliente = $row["cliente"];
        	$cuit = $row["cuit"];
            $direccion = $row["direccion"];
            $contrato = $row["contrato_id"];
            $zona = $row["zona"];
            $repartidor = $row["repartidor"];
            $fecha_envio = $row["fecha_envio"];
               
            // Cargo los datos en la tabla
            $templateProcessor->setValue('id#'.$index, utf8_encode(strip_tags($contrato)));
            $templateProcessor->setValue('cliente#'.$index, utf8_encode(strip_tags($cliente)));
            $templateProcessor->setValue('direccion#'.$index, utf8_encode(strip_tags($direccion)));
            $templateProcessor->setValue('localidad#'.$index, utf8_encode(strip_tags($zona)));
            
            $index += 1;
            
        }
        
        $templateProcessor->setValue('fechaenvio', utf8_encode(strip_tags($fecha_envio)));
        $templateProcessor->setValue('repartidor', utf8_encode(strip_tags($repartidor)));
        $templateProcessor->setValue('envio_id', utf8_encode(strip_tags($id)));
       
       

        
        // Armo el nombre del archivo a grabar
        $filename = 'caratula_envio_'.$id.'.docx';
        $fullFilename = 'generados'.DIRECTORY_SEPARATOR.$filename;
    
        // Guardo el archivo generado
        $templateProcessor->saveAs($fullFilename);    
        
        // Descarga el archivo en el cliente
        download_report($fullFilename);
    
        // Borra el archivo generado
        unlink($fullFilename); 
   
    }
    else {
        // Resultset vacio
        $mensaje = "No hay registros para listar";
        $result = array(
                "msg" =>limpiar_caracteres_especiales($mensaje) ,
                "estado" => true
            );
        
        echo json_encode($result);
    }
?>