<?php

    require 'utilities.php';
    require 'phpword_lib.php';
    require '../comunes_php/cors.php';
    require '../comunes_php/dbconfig.php';
 
    include '../comunes_php/Log.class.php'; 
    $log = new Log("app_trace", "./");
    $log->insert("llegue", false, false, false);

    use PhpOffice\PhpWord\Settings;
    use DocxMerge\DocxMerge;
    
    Settings::setOutputEscapingEnabled(false); //important, otherwise the XML will be written as is in the word document

    // array de archivos a mergear
    $archivos = array();

    // Conectar la BD
    $link = mysqli_connect(DB_SERVER, DB_USER, DB_PASS, DB_NAME) or die('Error de conexion con base de datos: ' . mysqli_connect_errno());
    
    mysqli_set_charset($link,'utf8');

    date_default_timezone_set('UTC');
    error_reporting(E_ALL);

    // Fecha del día
    $hoy = date('Y-m-d');

    // Obtengo los parametros enviados
    $repartidor_id = isset($_REQUEST['repartidor_id']) ? $_REQUEST['repartidor_id']: -1;
    $fecha_reparto = isset($_REQUEST['fecha_reparto']) ? $_REQUEST['fecha_reparto']: $hoy;
    
    // Plantilla a utilizar
    $template=TEMPLATE_DIR.DIRECTORY_SEPARATOR.pathinfo(__FILE__, PATHINFO_FILENAME).'.docx';
    
    $template_caratula=TEMPLATE_DIR.DIRECTORY_SEPARATOR.'envios.docx';

    $templateProcessor_caratula = new \PhpOffice\PhpWord\TemplateProcessor($template_caratula);

    $sql  = "SELECT ec.id, cc.id as contrato, cl.nombre as cliente, cc.direccion, zn.nombre as zona, r.nombre as repartidor, ec.fecha_envio ";
    $sql .= "FROM envios_cabecera ec, envios_detalle ed, contratos_cabecera cc, clientes cl, zonas zn, repartidores r ";
    $sql .= "WHERE ec.repartidor_id = $repartidor_id ";
    $sql .= "AND ec.id = ed.envio_id ";
    $sql .= "AND ed.contrato_id = cc.id "; 
    $sql .= "AND cc.cliente_id = cl.id ";
    $sql .= "AND cc.zona_id = zn.id ";
    $sql .= "AND ec.repartidor_id = r.id ";
    $sql .= "AND ec.fecha_envio = '$fecha_reparto'";

    
    // Ejecuto el query
    $resultado = mysqli_query($link, $sql);
    $rowcount = mysqli_num_rows($resultado);
    

    if ($rowcount > 0) {
        
        $index = 1;

        // Clono la fila de la tabla que va a mostrar los datos variables
        $templateProcessor_caratula->cloneRow('id', $rowcount);

        

        // Recorro el recordset
        while ($row = mysqli_fetch_array($resultado)) {

            $envio_id = $row["id"];
            $contrato = $row["contrato"];
            $cliente = $row["cliente"];
            $direccion = $row["direccion"];
            $zona = $row["zona"];
            $repartidor = $row["repartidor"];
            $fecha_envio = $row["fecha_envio"];            

            $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template);
            
            $templateProcessor->setValue('contrato', $contrato);
            $templateProcessor->setValue('fecha', date("d.m.Y"));
            $templateProcessor->setValue('cliente', $cliente);
            $templateProcessor->setValue('direccion', $direccion);
            $templateProcessor->setValue('zona', $zona);        
            
            $templateProcessor->setValue('cod_postal', '');

            // Cargo los datos en la tabla
            $templateProcessor_caratula->setValue('id#'.$index, utf8_encode(strip_tags($contrato)));
            $templateProcessor_caratula->setValue('cliente#'.$index, utf8_encode(strip_tags($cliente)));
            $templateProcessor_caratula->setValue('direccion#'.$index, utf8_encode(strip_tags($direccion)));
            $templateProcessor_caratula->setValue('localidad#'.$index, utf8_encode(strip_tags($zona)));

            // Busco los productos del contrato        
            $sql_prod  = "SELECT p.codigo, p.nombre ";
            $sql_prod .= "FROM contratos_detalle cd, productos p ";
            $sql_prod .= "WHERE cd.producto_id = p.id ";
            $sql_prod .= "AND cd.contrato_id = $contrato";
        
            $rs = mysqli_query($link, $sql_prod);
            $cant_reg = mysqli_num_rows($rs);

            $j = 1;

            $templateProcessor->cloneRow('cod_prod', $cant_reg);
            $templateProcessor->cloneRow('cod_prod_d', $cant_reg);

            while ($row_prod = mysqli_fetch_array($rs)) {
            

                $templateProcessor->setValue('cod_prod#'.$j, utf8_encode(strip_tags($row_prod["codigo"])));
                $templateProcessor->setValue('nombre_producto#'.$j, utf8_encode(strip_tags($row_prod["nombre"])));
                $templateProcessor->setValue('cod_prod_d#'.$j, utf8_encode(strip_tags($row_prod["codigo"])));
                $templateProcessor->setValue('nombre_producto_d#'.$j, utf8_encode(strip_tags($row_prod["nombre"])));

                $j++;
            }

                // Si no es el ultimo registro inserto un salto de linea
                //if ($index < $rowcount) {
                    $templateProcessor->setValue('pagebreakhere', PAGEBREAK);
                //}
                //else
                //{
                //    $templateProcessor->setValue('pagebreakhere', '');    
                //}

               
  
            $filename = 'envios_detalle_generado_'.$index.'.docx';
            $fullFilename = 'generados'.DIRECTORY_SEPARATOR.$filename;

            $templateProcessor->saveAs($fullFilename);

            $archivos[] = $fullFilename;

            $templateProcessor = null;
            
            // Control de contratos por envío
            $index++;

        }

        
        $templateProcessor_caratula->setValue('fechaenvio', utf8_encode(strip_tags($fecha_envio)));
        $templateProcessor_caratula->setValue('repartidor', utf8_encode(strip_tags($repartidor)));
        
        // Nombre del archivo que contiene la caratula
        $caratula = 'generados' . DIRECTORY_SEPARATOR . 'caratula_envio.docx';
        

        // Agrego la caratula a los archivos a mergear
        $archivos[] = $caratula;

        // Genero la caratula
        $templateProcessor_caratula->saveAs($caratula);
        $templateProcessor_caratula = null;

        // Nombre del archivo a enviar
        $doc_final = 'generados'.DIRECTORY_SEPARATOR."detalle_envio_$envio_id.docx";

        // Instancio la clase para hacer un merge de los archivos generados
        $dm = new DocxMerge();
        $dm->merge( $archivos,  $doc_final);
      
        // Genera un PDF
        //generarPdf($doc_final);
        
        // Descarga el archivo en el cliente
        download_report($doc_final);
        
        // Borra todos los archivos intermedios
        for ($m = 0; $m < count($archivos); $m++)
        {
            unlink($archivos[$m]); 
        }

        // Borra el archivo mergeado luego de haber hecho el download
        //unlink($doc_final); 
    }
    else 
    {
        // Resultset vacio
        $mensaje = "No hay registros para listar";
        $result = array(
                "msg" =>limpiar_caracteres_especiales($mensaje) ,
                "estado" => true
            );
        
        echo json_encode($result);
    }
    

?>