<?php

    require('config.php');
    require('funciones.php');

    $flagEspecial=false;  //es para tratar el codigo relacionado con las tabla muchos a muchos

    // get the HTTP method, path and body of the request
    $method = $_SERVER['REQUEST_METHOD'];
    $request = explode('/', trim($_SERVER['PATH_INFO'],'/'));
    $input = json_decode(file_get_contents('php://input'), true);

    $myfile = fopen("dump_input.txt", "a") or die("Unable to open file!");
    fwrite($myfile, "**********".date("d-m-Y H:i:s")."************\n");
    fwrite($myfile, print_r($input, true));
    fwrite($myfile, "*******************************\n");
    fclose($myfile);
    // Tratamiento del metodo OPTIONS
    if ($method == "OPTIONS") {
      header('Access-Control-Allow-Origin: *');
      header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Z-Key');
      //header('Content-Type: application/json');
      header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
      header('HTTP/1.1 200 OK');
      die();

    }

   // $myfile = fopen("dump_variabes.txt", "a") or die("Unable to open file!");




    // connect to the mysql database
    $link = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME) or die('Error de conexión con base de datos: ' . mysqli_connect_errno());
    mysqli_set_charset($link,'utf8');

    // la url viene de la forma /api/nombre_tabla/key

    // quita la palabra api que genera Celerio por default
    array_shift($request);

    // del segundo parametros extrae el nombre de la tabla, pero previo a usarlo hay que quitarle la "s" final y agregarle un _ antes de cada mayuscula encontrada
    $table = substr(preg_replace('/[^a-z0-9_]+/i','',array_shift($request)),0,-1);
    $table = armoNombre($table);
    $key = array_shift($request);

    // Para paginacion
    $offset = $input['lazyLoadEvent']['first'];
    $rows = $input['lazyLoadEvent']['rows'];


    $orderBy = isset($input['lazyLoadEvent']['sortField']) ? armoNombre($input['lazyLoadEvent']['sortField']) : '';
    $orderOrder = $input['lazyLoadEvent']['sortOrder'];

    $pk = $input['id'];
    $busqueda = $input['example'];

    // Obtiene las columnas y los valores desde el input object
    $columns = preg_replace('/[^a-z0-9_]+/i','',array_keys($input));
    $values = array_map(function ($value) use ($link)
                            {
                                if ($value===null) return null;
                                    if(is_array($value))
                                    {
                                        return $value;
                                    } else
                                    {
                                        return mysqli_real_escape_string($link,(string)$value);
                                    }
                            },array_values($input)
                        );

    // build the SET part of the SQL command
    $set = '';
    for ($i=0;$i<count($columns);$i++) {

                $set.=($i>0?',':'').(is_array($values[$i])?
                                    armoNombre($columns[$i].'Id'):
                                    armoNombre($columns[$i])).'=';
                $set.='"'.(is_array($values[$i])?
                                    $values[$i]['id']:
                                    $values[$i]).'"';
    }




    $busqueda=" ";

    // create SQL based on HTTP method
    switch ($method) {
      case 'GET':
        $sql = "select * from `$table`".($key?" WHERE borrado=0 and id=$key":''); break;
      case 'PUT':
        if ($pk===0)
            {
                switch ($table)
                {
                    case 'productos':
                        $flagEspecial=true;
                        InsertEspecial($link,$input,$table);
                        break;
                    case 'usuarios':
                        $flagEspecial=true;
                        InsertEspecial($link,$input,$table);
                        break;
                    case 'reclamos_contrato':
                        $flagEspecial=true;
                        InsertEspecial($link,$input,$table);
                        break;
                    default:

                       $sql = "insert into `$table` set $set"; break;
                        break;
                }
            }
        else
            {

                switch ($table)
                {
                    case 'productos':
                        $flagEspecial=true;
                        UpdateEspecial($link,$input,$table);
                    case 'usuarios':
                        $flagEspecial=true;
                        UpdateEspecial($link,$input,$table);

                        break;
                    default:
                        $sql = "update `$table` set $set where id=$pk"; break;
                        break;
                }

            }

      case 'POST':
          if ($key === "page") {
                $filtro = ArmoFiltro($input['example'], $link);
                //calculo el total de registros sin contar la paginacion
                $sql = "select * from `$table` $filtro and borrado=0  ";

                $result = mysqli_query($link, $sql);

                $totalRegistros= mysqli_num_rows($result);


                if ($orderBy!=='') {

                    $sqlOrder= " order by $orderBy ".($orderOrder==1?"ASC":"DESC");
                } else{
                    $sqlOrder="";
                }

                $sql = "select * from `$table` $filtro and borrado=0 $sqlOrder limit $offset,$rows";
                break;
            }
          if ($key === "complete") {
                //por aca entra la carga de las FK
                $criterio= $input['query'];

                if ($criterio===" " || is_null($criterio) ) {
                    $sql = "select * from `$table` where borrado=0 order by id   ";

                }
                else
                {
                    $sql = "select * from `$table` where lower(nombre) like trim(lower('%$criterio%')) and borrado=0 order by id   ";
                }
                break;
            }

          else {

        //fwrite($myfile, "no deberia haber pasado popr aca, es POST sin Page");
        //fwrite($myfile, "\n");
        //fclose($myfile);
        break;
          }

      case 'DELETE':
            $sql = "update  `$table` set borrado=1 where id=$key"; break;
    }

    //fwrite($myfile, $busqueda);
    //fwrite($myfile,  "\n");
  //  fwrite($myfile, $sql);
  //  fwrite($myfile,  "\n");
    // execute SQL statement
                    $myfile2 = fopen("dump_simple.txt", "a") or die("Unable to open file!");
                    fwrite($myfile2, $sql);
                    fwrite($myfile2, "\n");
                    fclose($myfile2);

    if (!$flagEspecial) {
        $result = mysqli_query($link, $sql);
        // die if SQL statement failed
        if (!$result) {
          http_response_code(404);
          die(mysqli_error($link));
        }

    }




    // Preparo la respuesta de acuerdo al metodo utilizado
    if ($method == 'GET') {
        // tratamiento especial para tabla productos (por ahora)

                switch ($table)
                {
                    case 'productos':
                        $flagEspecial=true;
                         echo desarmoNombre(procesoProductos($link, $result));
                        break;
                    case 'clientes':
                        $flagEspecial=true;
                         echo desarmoNombre(procesoClientes($link, $result));
                        break;
                    case 'materialesUsados':
                        $flagEspecial=true;
                         echo desarmoNombre(procesoMaterialesUsados($link, $result));
                        break;
                    case 'usuarios':
                        $flagEspecial=true;
                         echo desarmoNombre(procesoUsuarios($link, $result));
                        break;
                    default:

                        if (!$key) echo '[';
                        for ($i=0;$i<mysqli_num_rows($result);$i++) {
                            echo ($i>0?',':'').json_encode(mysqli_fetch_object($result), JSON_NUMERIC_CHECK);

                        }

                        if (!$key) echo ']';
                        break;
                }

    } elseif ($method == 'POST') {
        if ($key === "page") {
            $items = array();
            $resultado = array();

            switch($table)
            {
                case 'precio_productos':
                    $items = procesoPrecioProductos($link, $result);
                    break;

                default:

                    while($row = mysqli_fetch_object($result)) {

                        array_push($items, $row);

                    }
            } /* fin switch */


            $resultado["totalElements"] =$totalRegistros;
            $resultado["totalPages"] = ceil($resultado["totalElements"]/$rows);
            $resultado["content"] = $items;

            echo desarmoNombre(json_encode($resultado, JSON_NUMERIC_CHECK));

        }
        elseif ($key === "complete") {
              $items = array();

              while($row = mysqli_fetch_object($result)) {
                  array_push($items, $row);
              }

              echo json_encode($items, JSON_NUMERIC_CHECK);




        }
    } else {
        if ($pk===0) {
            $pk=mysqli_insert_id($link);
            $input['id']=$pk;
             echo desarmoNombre(json_encode($input, JSON_NUMERIC_CHECK));

        }
        else {
            echo mysqli_affected_rows($link);
        }
    }

    // close mysql connection
    mysqli_close($link);
 //   fclose($myfile);


?>
