<?php
    function ArmoFiltro($filtro, $bd) {
        // escape the columns and values from the input object

        $columns = preg_replace('/[^a-z0-9_]+/i','',array_keys($filtro));
        $values = array_map(function ($value) use ($bd)
                            {
                              if ($value===null) return null;
                              if(is_array($value)){
                                return $value;
                              } else {
                                  return mysqli_real_escape_string($bd,(string)$value);
                              }
                            },array_values($filtro));

        // build the where part of the SQL command
        $set = ' where 1=1 ';
        for ($i=0;$i<count($columns);$i++) {
            if (!is_null($values[$i]) && $values[$i]!==''&& !(is_array($values[$i]) && $columns[$i]=='id' )) {
                $set.=' and lower(`'.(is_array($values[$i])?
                                    armoNombre($columns[$i].'Id'):
                                    armoNombre($columns[$i])).'`) like lower(';
                $set.='"%'.(is_array($values[$i])?
                                    $values[$i]['id']:
                                    $values[$i]).'%")';
            }
        }
        return $set;
    }

    function is_assoc($array)
    {
        foreach (array_keys($array) as $k => $v) {
            if ($k !== $v)
                return true;
        }
        return false;
            //return is_array($var) && array_diff_key($var,array_keys(array_keys($var)));
    }

    // Arma el nombre de la tabla cambiando las mayúsculas por _minuscula
    function armoNombre($tabla) {

        $tabla_nueva = '';

        foreach (range('A', 'Z') as $letra) {
            $mayusculas[]= $letra;
        }

        foreach (range('a', 'z') as $letra) {
            $minusculas[]= "_".$letra;
        }


        $tabla_nueva = str_replace($mayusculas, $minusculas, $tabla);
        return $tabla_nueva;
    }

    // Arma el nombre de la tabla quitando el underscore y convirtiendo la primera minúscula
    // luego del mismo a mayúsculas
    function desarmoNombre($nombre) {

        $nombre_nuevo = '';


        $nombre_nuevo = preg_replace('/_(.?)/e',"strtoupper('$1')",$nombre);
        return $nombre_nuevo;
    }


    // Procesa los pedidos de informacion de la tabla productos y sus foreign keys
    function procesoProductos($bd, $resultado, $modo = 0) {

        $tipo_prod = array();
        $fabricas = array();
        $adicionales=array();

        $producto = mysqli_fetch_object($resultado);

        $sql_tipo_prod = 'select * from tipo_producto where id = '.$producto->tipo_producto_id;
        $sql_fabricas  = 'select fa.* from productos_por_fabrica pf, fabricas fa where fa.id = pf.fabrica_id and pf.producto_id = '.$producto->id;
        $sql_adicionales = 'select a.* from adicionales_por_producto ap, adicionales a where a.id = ap.adicional_id and ap.producto_id = '.$producto->id;

        $result_tipo_prod = mysqli_query($bd, $sql_tipo_prod);
        if ($result_tipo_prod) {
            $tipo_prod = mysqli_fetch_object($result_tipo_prod);
        }


        $result_fabricas = mysqli_query($bd, $sql_fabricas);
        if ($result_fabricas) {
            while($row = mysqli_fetch_object($result_fabricas)) {
                array_push($fabricas, $row);
            }
        }


        $result_adicionales = mysqli_query($bd, $sql_adicionales);
        if ($result_adicionales) {
            while($row = mysqli_fetch_object($result_adicionales)) {
                array_push($adicionales, $row);
            }
        }

        //////////////////////////////////////////////
        // Armo la estructura para enviar la respuesta
        //////////////////////////////////////////////

        // Se casteo a (int) para que funcionen los picklist
        $prod["id"] = $producto->id;
        $prod["nombre"] = $producto->nombre;
        $prod["codigo"] = $producto->codigo;
        $prod["pathFoto"] = $producto->path_foto;
        $prod["descripcion"] = $producto->descripcion;

        $prod["tipoProducto"] = $tipo_prod;
        $prod["adicionals"] = $adicionales;
        $prod["fabricas"] = $fabricas;

        if ($modo === 0) {
          return json_encode($prod, JSON_NUMERIC_CHECK);
        }
        else {
          return $prod;
        }

    }

    // Proceso solicitudes tabla precio_productos
    function procesoPrecioProductos($bd, $result) {

        $retorno = array();
        $precioProducto = array();

        if ($result) {

            while($row = mysqli_fetch_object($result)) {

                $sql_producto = "select * from productos where id = $row->producto_id";

                $resultProd = mysqli_query($bd, $sql_producto) or die(mysqli_error($bd));

                if ($resultProd) {
                    //$producto = json_decode(procesoProductos($link, $resultProd), TRUE);
                    $producto = procesoProductos($bd, $resultProd, 1);

                    //////////////////////////////////////////////
                    // Armo la estructura para enviar la respuesta
                    //////////////////////////////////////////////
                    
                    $retorno['id']['fechaInicio'] = $row->fecha_inicio;
                    $retorno['id']['productoId'] = $row->producto_id;
                    $retorno['id']['productoIdSet'] = isset($retorno['id']['productoId']) ? 'true' : 'false';
                    $retorno['id']['fechaInicioSet'] = isset($retorno['id']['fechaInicio']) ? 'true' : 'false';
                    $retorno['id']['empty'] = 'false';

                    $retorno['precio'] = $row->precio;
                    $retorno['fecha_fin'] = $row->fecha_fin;
                    $retorno['producto'] = $producto;

                    array_push($precioProducto, $retorno);

              }

              $sql_producto = "";

            }


            return $precioProducto;
        }

    }



    function procesoUsuarios($bd, $resultado) {

        $foreignKey1 = array();
        $foreignKey2 = array();

        $subtabla1 = array();

        $resultObjPpal = mysqli_fetch_object($resultado);



        $sql_FK1 = 'select * from tipo_perfiles where id = '.$resultObjPpal->perfil_id;
        $sql_FK2 = 'select * from tipo_sectores where id = '.$resultObjPpal->sector_id;


        $sql_subtabla1  = 'select fa.* from usuarios_por_fabrica us, fabricas fa where us.fabrica_id = fa.id and us.usuario_id = '.$resultObjPpal->id;

        $resultFK1 = mysqli_query($bd, $sql_FK1);
        if ($resultFK1) {
            $foreignKey1 = mysqli_fetch_object($resultFK1);
        }

        $resultFK2 = mysqli_query($bd, $sql_FK2);
        if ($resultFK2) {
            $foreignKey2 = mysqli_fetch_object($resultFK2);
        }

        $result_subtabla1 = mysqli_query($bd, $sql_subtabla1);
        if ($result_subtabla1) {
            while($row = mysqli_fetch_object($result_subtabla1)) {
                array_push($subtabla1, $row);
            }
        }


        //////////////////////////////////////////////
        // Armo la estructura para enviar la respuesta
        //////////////////////////////////////////////

        // Se casteo a (int) para que funcionen los picklist
        $retorno["id"] = $resultObjPpal->id;
        $retorno["login"] = $resultObjPpal->login;
        $retorno["clave"] = $resultObjPpal->clave;
        $retorno["habilitado"] = $resultObjPpal->habilitado;
        $retorno["nombre"] = $resultObjPpal->nombre;

        $retorno["perfil"] = $foreignKey1;
        $retorno["sector"] = $foreignKey2;

        $retorno["fabricas"] = $subtabla1;
       //$prod["fabricas"] = $fabricas;

        return json_encode($retorno, JSON_NUMERIC_CHECK);
    }

   function procesoClientes($bd, $resultado) {

        $tipo_prod = array();
        $fabricas = array();
        $adicionales=array();

        $cliente = mysqli_fetch_object($resultado);



        $sql_tipo_factura = 'select * from tipo_facturas where id = '.$cliente->tipo_factura_id;
        $sql_tipo_zona = 'select * from zonas where id = '.$cliente->zona_id;

        $result_tipo_factura = mysqli_query($bd, $sql_tipo_factura);
        if ($result_tipo_factura) {
            $tipo_factura = mysqli_fetch_object($result_tipo_factura);
        }


        $result_tipo_zona = mysqli_query($bd, $sql_tipo_zona);
        if ($result_tipo_zona) {
            $tipo_zona = mysqli_fetch_object($result_tipo_zona);
        }




        //////////////////////////////////////////////
        // Armo la estructura para enviar la respuesta
        //////////////////////////////////////////////

        $prod["id"] = $cliente->id;
        $prod["nombre"] = $cliente->nombre;
        $prod["cuit"] = $cliente->cuit;
        $prod["direccion"] = $cliente->direccion;
        $prod["bonificacion"] = $cliente->bonificacion;



        $prod["tipoFactura"] = $tipo_factura;
        $prod["zona"] = $tipo_zona;

        return json_encode($prod, JSON_NUMERIC_CHECK);
    }

 function procesoMaterialesUsados($bd, $resultado) {

        $tipoMateriaPrima = array();
        $tipoUnidad = array();

        $MaterialesUsados = mysqli_fetch_object($resultado);



        $sql_tipo_materia_prima = 'select * from tipo_materia_prima where id = '.$MaterialesUsados->materia_prima_id;
        $sql_tipo_unidad = 'select * from tipo_unidades where id = '.$MaterialesUsados->tipo_unidad_id;

        $tipo_materia_prima = mysqli_query($bd, $sql_tipo_materia_prima);
        if ($tipo_materia_prima) {
            $tipoMateriaPrima = mysqli_fetch_object($tipo_materia_prima);
        }


        $tipo_unidad = mysqli_query($bd, $sql_tipo_unidad);
        if ($tipo_unidad) {
            $tipoUnidad = mysqli_fetch_object($tipo_unidad);
        }




        //////////////////////////////////////////////
        // Armo la estructura para enviar la respuesta
        //////////////////////////////////////////////

        $prod["productoId"] = $MaterialesUsados->producto_id;
        $prod["adicionalId"] = $MaterialesUsados->adicional_id;
        $prod["cantidadUsada"] = $MaterialesUsados->cantidad_usada;



        $prod["materiaPrima"] = $tipoMateriaPrima;
        $prod["tipoUnidad"] = $tipoUnidad;

        return json_encode($prod, JSON_NUMERIC_CHECK);
    }

    function InsertEspecial($bd,$input,$tabla){

     $myfile = fopen("dump_insert_especial.txt", "a") or die("Unable to open file!");
    fwrite($myfile, "**********".date("d-m-Y H:i:s")."************\n");
    fwrite($myfile, "Entrada");
    fwrite($myfile, "*******************************\n");
    fclose($myfile);

         switch ($tabla)
                {
                    case 'productos':
                        $tipoProducto=     $input['tipoProducto'];

                        $fabricas=$input['fabricas'];
                        $adicionales=$input['adicionals'];

                        $sql  = "insert into productos (nombre,codigo,path_foto,tipo_producto_id,descripcion,borrado) ";
                        $sql  .= " values (";
                        $sql  .= " '$input[nombre]','$input[codigo]','$input[pathFoto]',$tipoProducto[id],'$input[descripcion]',0 " ;
                        $sql  .= ")";
                        $result = mysqli_query($bd, $sql);

                        if (!$result) {
                          http_response_code(404);
                          die(mysqli_error($bd));
                        }
                        break;
                    case 'usuarios':
                        $perfil= $input['perfil'];
                        $sector= $input['sector'];

                        $fabricas=$input['fabricas'];

                        $sql  = "insert into usuarios (id,login,clave,perfil_id,habilitado,nombre,sector_id) ";
                        $sql  .= " values (";
                        $sql  .= " $input[id],'$input[login]','$input[clave]',$perfil[id],$input[habilitado],'$input[nombre]',$sector[id] " ;
                        $sql  .= ")";
                        $result = mysqli_query($bd, $sql);


                        $myfile = fopen("dump_insert_especial.txt", "a") or die("Unable to open file!");
                        fwrite($myfile, "**********".date("d-m-Y H:i:s")."************\n");
                        fwrite($myfile, $sql);
                        fwrite($myfile, "*******************************\n");
                        fclose($myfile);


                        if (!$result) {
                          http_response_code(404);
                          die(mysqli_error($bd));
                        }
                        break;

                }


    };

    function UpdateEspecial($bd,$input,$tabla){
    $myfile = fopen("dump_PROD.txt", "a") or die("Unable to open file!");

    fwrite($myfile, "no deberia haber pasado popr aca, es POST sin Page");
    fwrite($myfile, print_r($input, true));

    fwrite($myfile, "\n");

    fclose($myfile);
         switch ($tabla)
                {
                    case 'productos':

                        $tipoProducto=$input['tipoProducto'];


                        $sql  = "update productos set ";
                        $sql  .= " nombre='$input[nombre]',";
                        $sql  .= " codigo='$input[codigo]',";
                        $sql  .= " path_foto='$input[pathFoto]',";
                        $sql  .= " tipo_producto_id=$tipoProducto[id],";
                        $sql  .= " descripcion='$input[descripcion]' where id= $input[id]"  ;
                        $result = mysqli_query($bd, $sql);

                        if (!$result) {
                          http_response_code(404);
                          die(mysqli_error($bd));
                        }
                        //delete & insert de los productos por fabrica
                        $fabricas=$input['fabricas'];
                        $sql  = "delete from productos_por_fabrica where producto_id=$input[id]"  ;
                        $result = mysqli_query($bd, $sql);



                        foreach ($fabricas as $key1 => $value1) {
                                $sql = "INSERT INTO productos_por_fabrica (producto_id,fabrica_id) values ($input[id],$value1[id]) ";
                                $result = mysqli_query($bd, $sql);
                                 if (!$result) {
                                  http_response_code(404);
                                  die(mysqli_error($bd));
                                }
                        }



                        //delete & insert de los adicionales por producto
                        $adicionales=$input['adicionals'];

                        $sql  = "delete from adicionales_por_producto where producto_id= $input[id]"  ;
                        $result = mysqli_query($bd, $sql);

                        if (!$result) {
                          http_response_code(404);
                          die(mysqli_error($bd));
                        }

                        foreach ($adicionales as $key1 => $value1) {
                                $sql = "INSERT INTO adicionales_por_producto (producto_id,adicional_id) values ($input[id],$value1[id]) ";
                                $result = mysqli_query($bd, $sql);
                                 if (!$result) {
                                  http_response_code(404);
                                  die(mysqli_error($bd));
                                }
                        }
                        break;
                    case 'usuarios':

                        $perfil= $input['perfil'];
                        $sector= $input['sector'];




                        $sql  = "update usuarios set ";
                        $sql  .= " nombre='$input[nombre]',";
                        $sql  .= " clave='$input[clave]',";
                        $sql  .= " habilitado=$input[habilitado],";
                        $sql  .= " login='$input[login]',";
                        $sql  .= " sector_id=$sector[id],";
                        $sql  .= " perfil_id=$perfil[id] where id= $input[id]"  ;
                        $result = mysqli_query($bd, $sql);

                        if (!$result) {
                          http_response_code(404);
                          die(mysqli_error($bd));
                        }
                        //delete & insert de los productos por fabrica
                        $fabricas=$input['fabricas'];
                        $sql  = "delete from usuarios_por_fabrica where usuario_id=$input[id]"  ;
                        $result = mysqli_query($bd, $sql);



                        foreach ($fabricas as $key1 => $value1) {
                                $sql = "INSERT INTO usuarios_por_fabrica (usuario_id,fabrica_id) values ($input[id],$value1[id]) ";
                                $result = mysqli_query($bd, $sql);
                                 if (!$result) {
                                  http_response_code(404);
                                  die(mysqli_error($bd));
                                }
                        }



                        break;
                    }

    };



    ?>
