<?php
// $Id: ec_receipt.refund_alloc.inc,v 1.1.2.1 2009/05/08 07:18:09 gordon Exp $

/**
 * Implementation of hook_alloc_load().
 */
function ec_receipt_refund_alloc_load($erid) {
  return $erid;
}

/**
 * Implementation of hook_alloc_get_currency().
 */
function ec_receipt_refund_alloc_get_currency($erid) {
  if ($receipt = ec_receipt_load($erid)) {
    return $receipt->currency;
  }
}

/**
 * Implementation of hook_alloc_get_total().
 */
function ec_receipt_refund_alloc_get_total($erid) {
  if ($receipt = ec_receipt_load($erid)) {
    return $receipt->amount;
  }
}

/**
 * Implementation of hook_alloc_allocation().
 */
function ec_receipt_refund_alloc_allocation($erid, $balance) {
  if ($receipt = ec_receipt_load($erid)) {
    $receipt->status = RECEIPT_STATUS_REFUND_PENDING;
    ec_receipt_save($receipt);
    watchdog('ec_receipt', 'Receipt !erid refunded to customer.', array('!erid' => $erid));
  }
}
