<?php
// $Id: ec-views-exposed-form-fieldset.tpl.php,v 1.1.2.1 2009/03/26 11:40:41 gordon Exp $
/**
 * @file views-exposed-form.tpl.php
 *
 * This template handles the layout of the views exposed filter form.
 *
 * Variables available:
 * - $widgets: An array of exposed form widgets. Each widget contains:
 * - $widget->label: The visible label to print. May be optional.
 * - $widget->operator: The operator for the widget. May be optional.
 * - $widget->widget: The widget itself.
 * - $button: The submit button for the form.
 *
 * @ingroup views_templates
 */
?>
<div class="views-exposed-widgets clear-block">
  <?php foreach($widgets as $id => $widget): ?>
    <div class="views-exposed-widget">
      <?php if (!empty($widget->label)): ?>
        <label>
          <?php print $widget->label; ?>
        </label>
      <?php endif; ?>
      <?php if (!empty($widget->operator)): ?>
        <div class="views-operator">
          <?php print $widget->operator; ?>
        </div>
      <?php endif; ?>
      <div class="views-widget">
        <?php print $widget->widget; ?>
      </div>
    </div>
  <?php endforeach; ?>
</div>
